```jsx
import SvgIcon from '@/components/shared/SvgIcon'

const ImageSvgIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            id="Outline"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            fill="currentColor"
        >
            <path d="M19,0H5A5.006,5.006,0,0,0,0,5V19a5.006,5.006,0,0,0,5,5H19a5.006,5.006,0,0,0,5-5V5A5.006,5.006,0,0,0,19,0ZM5,2H19a3,3,0,0,1,3,3V19a2.951,2.951,0,0,1-.3,1.285l-9.163-9.163a5,5,0,0,0-7.072,0L2,14.586V5A3,3,0,0,1,5,2ZM5,22a3,3,0,0,1-3-3V17.414l4.878-4.878a3,3,0,0,1,4.244,0L20.285,21.7A2.951,2.951,0,0,1,19,22Z" />
            <path d="M16,10.5A3.5,3.5,0,1,0,12.5,7,3.5,3.5,0,0,0,16,10.5Zm0-5A1.5,1.5,0,1,1,14.5,7,1.5,1.5,0,0,1,16,5.5Z" />
        </svg>
    )
}

const CoffeeSvgIcon = () => {
    return (
        <svg width="1em" height="1em" viewBox="0 0 56.205 81.003">
            <g id="_x38_">
                <g>
                    <path
                        fill="#EDEDED"
                        d="M51.284,20.513l-4.272,51.054c-0.317,4.422-4.464,7.866-9.473,7.866H18.666
						c-5.01,0-9.157-3.444-9.473-7.867L4.93,20.513H51.284z"
                    />
                </g>
                <g>
                    <polygon
                        fill="#EDEDED"
                        points="28.107,20.045 28.107,20.279 4.454,20.279 4.436,20.045 		"
                    />
                    <path
                        d="M28.107,22.279H4.454c-1.047,0-1.916-0.807-1.994-1.851l-0.018-0.235c-0.042-0.555,0.149-1.102,0.528-1.51
						c0.378-0.408,0.909-0.64,1.466-0.64h23.671c1.104,0,2,0.896,2,2v0.235C30.107,21.384,29.212,22.279,28.107,22.279z"
                    />
                </g>
                <g>
                    <polygon
                        fill="#EDEDED"
                        points="51.777,20.045 51.759,20.279 28.107,20.279 28.107,20.045 		"
                    />
                    <path
                        d="M51.76,22.279H28.107c-1.104,0-2-0.896-2-2v-0.235c0-1.104,0.896-2,2-2h23.67c0.557,0,1.088,0.232,1.466,0.64
						c0.379,0.408,0.57,0.955,0.528,1.51l-0.018,0.235C53.676,21.472,52.807,22.279,51.76,22.279z"
                    />
                </g>
                <g>
                    <path
                        fill="#FCFAFB"
                        d="M45.137,20.513l-3.141,51.054c-0.233,4.422-3.281,7.866-6.964,7.866H21.157
						c-3.683,0-6.732-3.444-6.964-7.867l-3.134-51.052H45.137z"
                    />
                </g>
                <g>
                    <path
                        d="M39.6,81.003H16.605c-5.37,0-9.842-4.198-10.181-9.558l-3.77-51.033c-0.037-0.501,0.136-0.994,0.478-1.362
						c0.341-0.367,0.82-0.576,1.322-0.576H51.76c0.502,0,0.981,0.209,1.322,0.577c0.341,0.367,0.515,0.861,0.478,1.361L49.78,71.465
						C49.442,76.806,44.97,81.003,39.6,81.003z M6.397,22.084l3.628,49.114c0.22,3.483,3.11,6.195,6.58,6.195H39.6
						c3.47,0,6.359-2.713,6.579-6.176l3.637-49.134H6.397z"
                    />
                </g>
                <g>
                    <path
                        fill="#EDEDED"
                        d="M54.205,15.686v4.593H2v-4.593c0-2.572,2.085-4.656,4.666-4.656h42.883
						C52.12,11.029,54.205,13.114,54.205,15.686z"
                    />
                </g>
                <g>
                    <path
                        fill="#FCFAFB"
                        d="M44.438,15.679v4.593H11.767v-4.593c0-2.572,1.305-4.656,2.92-4.656h26.837
						C43.133,11.022,44.438,13.107,44.438,15.679z"
                    />
                </g>
                <g>
                    <path
                        d="M0,20.279l0-4.593c0-3.67,2.986-6.657,6.657-6.657H49.54c3.675,0,6.666,2.986,6.666,6.657v4.593c0,1.104-0.896,2-2,2H2
						C0.896,22.279,0,21.384,0,20.279z M52.205,15.686c0-1.465-1.196-2.657-2.666-2.657H6.657C5.192,13.029,4,14.221,4,15.686v2.593
						h48.205V15.686z"
                    />
                </g>
                <g>
                    <path
                        fill="#EDEDED"
                        d="M43.338,2H12.912c-1.527,0-2.862,1.031-3.249,2.508l-1.705,6.514h40.297l-1.664-6.497
						C46.211,3.039,44.872,2,43.338,2z"
                    />
                    <path
                        d="M48.256,13.022H7.958c-0.62,0-1.204-0.287-1.583-0.778s-0.509-1.129-0.352-1.729l1.705-6.515
						C8.345,1.646,10.477,0,12.912,0h30.426c2.448,0,4.583,1.657,5.191,4.028l1.664,6.498c0.153,0.599,0.021,1.234-0.357,1.722
						C49.457,12.737,48.874,13.022,48.256,13.022z M10.549,9.022h35.13l-1.024-4.001C44.5,4.42,43.959,4,43.338,4H12.912
						c-0.617,0-1.158,0.417-1.314,1.014L10.549,9.022z"
                    />
                </g>
                <g>
                    <polygon
                        fill="#9AC97F"
                        points="49.648,64.265 6.565,64.265 4.683,34.892 51.531,34.892 		"
                    />
                    <path
                        d="M49.648,66.265H6.565c-1.055,0-1.929-0.819-1.996-1.872L2.687,35.02c-0.035-0.552,0.159-1.093,0.537-1.496
						c0.378-0.403,0.906-0.632,1.459-0.632h46.849c0.553,0,1.081,0.229,1.459,0.632c0.378,0.403,0.572,0.944,0.537,1.496l-1.883,29.374
						C51.577,65.446,50.703,66.265,49.648,66.265z M8.441,62.265h39.331l1.627-25.374H6.814L8.441,62.265z"
                    />
                </g>
                <g>
                    <path
                        fill="#FFFFFF"
                        d="M39.942,52.473H16.271c-1.381,0-2.5-1.119-2.5-2.5s1.119-2.5,2.5-2.5h23.671c1.381,0,2.5,1.119,2.5,2.5
						S41.323,52.473,39.942,52.473z"
                    />
                </g>
                <g>
                    <circle fill="#FFFFFF" cx="28.098" cy="49.973" r="7.5" />
                </g>
            </g>
        </svg>
    )
}

const Example = () => {
    return (
        <div className="flex items-center gap-4">
            <SvgIcon className="text-4xl text-blue-600">
                <ImageSvgIcon />
            </SvgIcon>
            <SvgIcon className="text-4xl">
                <CoffeeSvgIcon />
            </SvgIcon>
        </div>
    )
}

export default Example
```
