
import { UI_COMPONENTS_PREFIX_PATH } from '@/constants/route.constant'
import { APP_PREFIX_PATH } from '@/constants/route.constant'
import {
    NAV_ITEM_TYPE_TITLE,
    NAV_ITEM_TYPE_COLLAPSE,
    NAV_ITEM_TYPE_ITEM,
} from '@/constants/navigation.constant'
import { ADMIN, USER } from '@/constants/roles.constant'
import type { NavigationTree } from '@/@types/navigation'

const usersNavigationConfig: NavigationTree[] = [
    {
        key: 'users.crm',
        path: '',
        title: 'Users',
        translateKey: 'nav.usersCrm.crm',
        icon: 'customUsersIcon',
        type: NAV_ITEM_TYPE_COLLAPSE,
        authority: [ADMIN, USER],
        subMenu: [
            {
                key: 'usersCrm.addUsers',
                path: `${APP_PREFIX_PATH}/users/addUsers`,
                title: 'Add Users',
                translateKey: 'nav.usersCrm.addUsers',
                icon: '',
                type: NAV_ITEM_TYPE_ITEM,
                authority: [ADMIN, USER],
                subMenu: [],
            },
            {
                key: 'usersCrm.allUsers',
                path: `${APP_PREFIX_PATH}/users/allUsers`,
                title: 'All Users',
                translateKey: 'nav.usersCrm.allUsers',
                icon: '',
                type: NAV_ITEM_TYPE_ITEM,
                authority: [ADMIN, USER],
                subMenu: [],
            },
        ],
    },
]

export default usersNavigationConfig
