import { createSlice, PayloadAction } from '@reduxjs/toolkit'

export type appListState = {
    appList:{
        app_id: string
        name: string
        picture: string
        app_url: string
    }[]
}

const initialState : appListState={
    appList:[]
}

const  appListSlice = createSlice({
    name: 'appList',
    initialState,
    reducers: {
        setAppListReducer:(state,action: PayloadAction<[]>)=>{
            state.appList=action.payload
        }
    }
})

export const {setAppListReducer}=appListSlice.actions

export default appListSlice

