
const {executeQuery} = require("../../utils/utils");
const { Apps_Table } = require("../../Database/Table_Names/TB_Name_Collection");

async function createApp(app_id, picture, name, app_url, app_description, status, created_date) {
  const sql = `INSERT INTO ${Apps_Table}(app_id, picture, name, app_url, app_description, status, created_date) VALUES(?, ?, ?, ?, ?, ?, ?)`;
  const params = [app_id, picture, name, app_url, app_description, status, created_date];

  return executeQuery(sql, params);
}

async function updateApp(app_id, picture, name, app_url, app_description, status, updated_date) {
  const sql = `UPDATE ${Apps_Table} SET ${picture && "picture = ?,"} name = ?, app_url = ?, app_description = ?, status = ?, updated_date = ? WHERE app_id = ? AND is_deleted <> 1`;
  const params = picture=="" ? [ name, app_url, app_description, status, updated_date, app_id] :[picture, name, app_url, app_description, status, updated_date, app_id];

  return executeQuery(sql, params);
}

async function getTotalApps(search_text) {
  const sql = `SELECT COUNT(*) AS total FROM ${Apps_Table} WHERE name LIKE '%${search_text.replace(/'/g, "''")}%' AND is_deleted <> 1`;

  return executeQuery(sql, []);
}

async function getAllApps(current_page, per_page, search_text) {
  const offset = (current_page - 1) * per_page;
  const sql = `SELECT app_id,name,picture,app_url, app_description FROM ${Apps_Table} WHERE name LIKE '%${search_text.replace(/'/g, "''")}%' AND is_deleted <> 1 ORDER BY created_date ASC LIMIT ${per_page} OFFSET ${offset}`; // is_deleted != 1

  return executeQuery(sql, []);
}

async function getAppById(app_id) {
  const sql = `SELECT app_id,name,picture,SUBSTRING_INDEX(picture, '/', -1) AS picture_name, app_url, app_description, status FROM ${Apps_Table} WHERE app_id = ? AND  is_deleted <> 1`;
  const params = [app_id];

  return executeQuery(sql, params);
}

async function deleteApp(app_id) {
  const sql = `UPDATE ${Apps_Table} SET is_deleted = ? WHERE app_id = ? AND is_deleted <> 1`;
  const params = [1, app_id];

  return executeQuery(sql, params);
}

module.exports = { createApp, updateApp, getTotalApps, getAllApps, getAppById, deleteApp };
