import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import { CognitoIdentityProviderClient } from "./CognitoIdentityProviderClient";
import {
  AddCustomAttributesCommandInput,
  AddCustomAttributesCommandOutput,
} from "./commands/AddCustomAttributesCommand";
import {
  AdminAddUserToGroupCommandInput,
  AdminAddUserToGroupCommandOutput,
} from "./commands/AdminAddUserToGroupCommand";
import {
  AdminConfirmSignUpCommandInput,
  AdminConfirmSignUpCommandOutput,
} from "./commands/AdminConfirmSignUpCommand";
import {
  AdminCreateUserCommandInput,
  AdminCreateUserCommandOutput,
} from "./commands/AdminCreateUserCommand";
import {
  AdminDeleteUserAttributesCommandInput,
  AdminDeleteUserAttributesCommandOutput,
} from "./commands/AdminDeleteUserAttributesCommand";
import {
  AdminDeleteUserCommandInput,
  AdminDeleteUserCommandOutput,
} from "./commands/AdminDeleteUserCommand";
import {
  AdminDisableProviderForUserCommandInput,
  AdminDisableProviderForUserCommandOutput,
} from "./commands/AdminDisableProviderForUserCommand";
import {
  AdminDisableUserCommandInput,
  AdminDisableUserCommandOutput,
} from "./commands/AdminDisableUserCommand";
import {
  AdminEnableUserCommandInput,
  AdminEnableUserCommandOutput,
} from "./commands/AdminEnableUserCommand";
import {
  AdminForgetDeviceCommandInput,
  AdminForgetDeviceCommandOutput,
} from "./commands/AdminForgetDeviceCommand";
import {
  AdminGetDeviceCommandInput,
  AdminGetDeviceCommandOutput,
} from "./commands/AdminGetDeviceCommand";
import {
  AdminGetUserCommandInput,
  AdminGetUserCommandOutput,
} from "./commands/AdminGetUserCommand";
import {
  AdminInitiateAuthCommandInput,
  AdminInitiateAuthCommandOutput,
} from "./commands/AdminInitiateAuthCommand";
import {
  AdminLinkProviderForUserCommandInput,
  AdminLinkProviderForUserCommandOutput,
} from "./commands/AdminLinkProviderForUserCommand";
import {
  AdminListDevicesCommandInput,
  AdminListDevicesCommandOutput,
} from "./commands/AdminListDevicesCommand";
import {
  AdminListGroupsForUserCommandInput,
  AdminListGroupsForUserCommandOutput,
} from "./commands/AdminListGroupsForUserCommand";
import {
  AdminListUserAuthEventsCommandInput,
  AdminListUserAuthEventsCommandOutput,
} from "./commands/AdminListUserAuthEventsCommand";
import {
  AdminRemoveUserFromGroupCommandInput,
  AdminRemoveUserFromGroupCommandOutput,
} from "./commands/AdminRemoveUserFromGroupCommand";
import {
  AdminResetUserPasswordCommandInput,
  AdminResetUserPasswordCommandOutput,
} from "./commands/AdminResetUserPasswordCommand";
import {
  AdminRespondToAuthChallengeCommandInput,
  AdminRespondToAuthChallengeCommandOutput,
} from "./commands/AdminRespondToAuthChallengeCommand";
import {
  AdminSetUserMFAPreferenceCommandInput,
  AdminSetUserMFAPreferenceCommandOutput,
} from "./commands/AdminSetUserMFAPreferenceCommand";
import {
  AdminSetUserPasswordCommandInput,
  AdminSetUserPasswordCommandOutput,
} from "./commands/AdminSetUserPasswordCommand";
import {
  AdminSetUserSettingsCommandInput,
  AdminSetUserSettingsCommandOutput,
} from "./commands/AdminSetUserSettingsCommand";
import {
  AdminUpdateAuthEventFeedbackCommandInput,
  AdminUpdateAuthEventFeedbackCommandOutput,
} from "./commands/AdminUpdateAuthEventFeedbackCommand";
import {
  AdminUpdateDeviceStatusCommandInput,
  AdminUpdateDeviceStatusCommandOutput,
} from "./commands/AdminUpdateDeviceStatusCommand";
import {
  AdminUpdateUserAttributesCommandInput,
  AdminUpdateUserAttributesCommandOutput,
} from "./commands/AdminUpdateUserAttributesCommand";
import {
  AdminUserGlobalSignOutCommandInput,
  AdminUserGlobalSignOutCommandOutput,
} from "./commands/AdminUserGlobalSignOutCommand";
import {
  AssociateSoftwareTokenCommandInput,
  AssociateSoftwareTokenCommandOutput,
} from "./commands/AssociateSoftwareTokenCommand";
import {
  ChangePasswordCommandInput,
  ChangePasswordCommandOutput,
} from "./commands/ChangePasswordCommand";
import {
  ConfirmDeviceCommandInput,
  ConfirmDeviceCommandOutput,
} from "./commands/ConfirmDeviceCommand";
import {
  ConfirmForgotPasswordCommandInput,
  ConfirmForgotPasswordCommandOutput,
} from "./commands/ConfirmForgotPasswordCommand";
import {
  ConfirmSignUpCommandInput,
  ConfirmSignUpCommandOutput,
} from "./commands/ConfirmSignUpCommand";
import {
  CreateGroupCommandInput,
  CreateGroupCommandOutput,
} from "./commands/CreateGroupCommand";
import {
  CreateIdentityProviderCommandInput,
  CreateIdentityProviderCommandOutput,
} from "./commands/CreateIdentityProviderCommand";
import {
  CreateResourceServerCommandInput,
  CreateResourceServerCommandOutput,
} from "./commands/CreateResourceServerCommand";
import {
  CreateUserImportJobCommandInput,
  CreateUserImportJobCommandOutput,
} from "./commands/CreateUserImportJobCommand";
import {
  CreateUserPoolClientCommandInput,
  CreateUserPoolClientCommandOutput,
} from "./commands/CreateUserPoolClientCommand";
import {
  CreateUserPoolCommandInput,
  CreateUserPoolCommandOutput,
} from "./commands/CreateUserPoolCommand";
import {
  CreateUserPoolDomainCommandInput,
  CreateUserPoolDomainCommandOutput,
} from "./commands/CreateUserPoolDomainCommand";
import {
  DeleteGroupCommandInput,
  DeleteGroupCommandOutput,
} from "./commands/DeleteGroupCommand";
import {
  DeleteIdentityProviderCommandInput,
  DeleteIdentityProviderCommandOutput,
} from "./commands/DeleteIdentityProviderCommand";
import {
  DeleteResourceServerCommandInput,
  DeleteResourceServerCommandOutput,
} from "./commands/DeleteResourceServerCommand";
import {
  DeleteUserAttributesCommandInput,
  DeleteUserAttributesCommandOutput,
} from "./commands/DeleteUserAttributesCommand";
import {
  DeleteUserCommandInput,
  DeleteUserCommandOutput,
} from "./commands/DeleteUserCommand";
import {
  DeleteUserPoolClientCommandInput,
  DeleteUserPoolClientCommandOutput,
} from "./commands/DeleteUserPoolClientCommand";
import {
  DeleteUserPoolCommandInput,
  DeleteUserPoolCommandOutput,
} from "./commands/DeleteUserPoolCommand";
import {
  DeleteUserPoolDomainCommandInput,
  DeleteUserPoolDomainCommandOutput,
} from "./commands/DeleteUserPoolDomainCommand";
import {
  DescribeIdentityProviderCommandInput,
  DescribeIdentityProviderCommandOutput,
} from "./commands/DescribeIdentityProviderCommand";
import {
  DescribeResourceServerCommandInput,
  DescribeResourceServerCommandOutput,
} from "./commands/DescribeResourceServerCommand";
import {
  DescribeRiskConfigurationCommandInput,
  DescribeRiskConfigurationCommandOutput,
} from "./commands/DescribeRiskConfigurationCommand";
import {
  DescribeUserImportJobCommandInput,
  DescribeUserImportJobCommandOutput,
} from "./commands/DescribeUserImportJobCommand";
import {
  DescribeUserPoolClientCommandInput,
  DescribeUserPoolClientCommandOutput,
} from "./commands/DescribeUserPoolClientCommand";
import {
  DescribeUserPoolCommandInput,
  DescribeUserPoolCommandOutput,
} from "./commands/DescribeUserPoolCommand";
import {
  DescribeUserPoolDomainCommandInput,
  DescribeUserPoolDomainCommandOutput,
} from "./commands/DescribeUserPoolDomainCommand";
import {
  ForgetDeviceCommandInput,
  ForgetDeviceCommandOutput,
} from "./commands/ForgetDeviceCommand";
import {
  ForgotPasswordCommandInput,
  ForgotPasswordCommandOutput,
} from "./commands/ForgotPasswordCommand";
import {
  GetCSVHeaderCommandInput,
  GetCSVHeaderCommandOutput,
} from "./commands/GetCSVHeaderCommand";
import {
  GetDeviceCommandInput,
  GetDeviceCommandOutput,
} from "./commands/GetDeviceCommand";
import {
  GetGroupCommandInput,
  GetGroupCommandOutput,
} from "./commands/GetGroupCommand";
import {
  GetIdentityProviderByIdentifierCommandInput,
  GetIdentityProviderByIdentifierCommandOutput,
} from "./commands/GetIdentityProviderByIdentifierCommand";
import {
  GetLogDeliveryConfigurationCommandInput,
  GetLogDeliveryConfigurationCommandOutput,
} from "./commands/GetLogDeliveryConfigurationCommand";
import {
  GetSigningCertificateCommandInput,
  GetSigningCertificateCommandOutput,
} from "./commands/GetSigningCertificateCommand";
import {
  GetUICustomizationCommandInput,
  GetUICustomizationCommandOutput,
} from "./commands/GetUICustomizationCommand";
import {
  GetUserAttributeVerificationCodeCommandInput,
  GetUserAttributeVerificationCodeCommandOutput,
} from "./commands/GetUserAttributeVerificationCodeCommand";
import {
  GetUserCommandInput,
  GetUserCommandOutput,
} from "./commands/GetUserCommand";
import {
  GetUserPoolMfaConfigCommandInput,
  GetUserPoolMfaConfigCommandOutput,
} from "./commands/GetUserPoolMfaConfigCommand";
import {
  GlobalSignOutCommandInput,
  GlobalSignOutCommandOutput,
} from "./commands/GlobalSignOutCommand";
import {
  InitiateAuthCommandInput,
  InitiateAuthCommandOutput,
} from "./commands/InitiateAuthCommand";
import {
  ListDevicesCommandInput,
  ListDevicesCommandOutput,
} from "./commands/ListDevicesCommand";
import {
  ListGroupsCommandInput,
  ListGroupsCommandOutput,
} from "./commands/ListGroupsCommand";
import {
  ListIdentityProvidersCommandInput,
  ListIdentityProvidersCommandOutput,
} from "./commands/ListIdentityProvidersCommand";
import {
  ListResourceServersCommandInput,
  ListResourceServersCommandOutput,
} from "./commands/ListResourceServersCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ListUserImportJobsCommandInput,
  ListUserImportJobsCommandOutput,
} from "./commands/ListUserImportJobsCommand";
import {
  ListUserPoolClientsCommandInput,
  ListUserPoolClientsCommandOutput,
} from "./commands/ListUserPoolClientsCommand";
import {
  ListUserPoolsCommandInput,
  ListUserPoolsCommandOutput,
} from "./commands/ListUserPoolsCommand";
import {
  ListUsersCommandInput,
  ListUsersCommandOutput,
} from "./commands/ListUsersCommand";
import {
  ListUsersInGroupCommandInput,
  ListUsersInGroupCommandOutput,
} from "./commands/ListUsersInGroupCommand";
import {
  ResendConfirmationCodeCommandInput,
  ResendConfirmationCodeCommandOutput,
} from "./commands/ResendConfirmationCodeCommand";
import {
  RespondToAuthChallengeCommandInput,
  RespondToAuthChallengeCommandOutput,
} from "./commands/RespondToAuthChallengeCommand";
import {
  RevokeTokenCommandInput,
  RevokeTokenCommandOutput,
} from "./commands/RevokeTokenCommand";
import {
  SetLogDeliveryConfigurationCommandInput,
  SetLogDeliveryConfigurationCommandOutput,
} from "./commands/SetLogDeliveryConfigurationCommand";
import {
  SetRiskConfigurationCommandInput,
  SetRiskConfigurationCommandOutput,
} from "./commands/SetRiskConfigurationCommand";
import {
  SetUICustomizationCommandInput,
  SetUICustomizationCommandOutput,
} from "./commands/SetUICustomizationCommand";
import {
  SetUserMFAPreferenceCommandInput,
  SetUserMFAPreferenceCommandOutput,
} from "./commands/SetUserMFAPreferenceCommand";
import {
  SetUserPoolMfaConfigCommandInput,
  SetUserPoolMfaConfigCommandOutput,
} from "./commands/SetUserPoolMfaConfigCommand";
import {
  SetUserSettingsCommandInput,
  SetUserSettingsCommandOutput,
} from "./commands/SetUserSettingsCommand";
import {
  SignUpCommandInput,
  SignUpCommandOutput,
} from "./commands/SignUpCommand";
import {
  StartUserImportJobCommandInput,
  StartUserImportJobCommandOutput,
} from "./commands/StartUserImportJobCommand";
import {
  StopUserImportJobCommandInput,
  StopUserImportJobCommandOutput,
} from "./commands/StopUserImportJobCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateAuthEventFeedbackCommandInput,
  UpdateAuthEventFeedbackCommandOutput,
} from "./commands/UpdateAuthEventFeedbackCommand";
import {
  UpdateDeviceStatusCommandInput,
  UpdateDeviceStatusCommandOutput,
} from "./commands/UpdateDeviceStatusCommand";
import {
  UpdateGroupCommandInput,
  UpdateGroupCommandOutput,
} from "./commands/UpdateGroupCommand";
import {
  UpdateIdentityProviderCommandInput,
  UpdateIdentityProviderCommandOutput,
} from "./commands/UpdateIdentityProviderCommand";
import {
  UpdateResourceServerCommandInput,
  UpdateResourceServerCommandOutput,
} from "./commands/UpdateResourceServerCommand";
import {
  UpdateUserAttributesCommandInput,
  UpdateUserAttributesCommandOutput,
} from "./commands/UpdateUserAttributesCommand";
import {
  UpdateUserPoolClientCommandInput,
  UpdateUserPoolClientCommandOutput,
} from "./commands/UpdateUserPoolClientCommand";
import {
  UpdateUserPoolCommandInput,
  UpdateUserPoolCommandOutput,
} from "./commands/UpdateUserPoolCommand";
import {
  UpdateUserPoolDomainCommandInput,
  UpdateUserPoolDomainCommandOutput,
} from "./commands/UpdateUserPoolDomainCommand";
import {
  VerifySoftwareTokenCommandInput,
  VerifySoftwareTokenCommandOutput,
} from "./commands/VerifySoftwareTokenCommand";
import {
  VerifyUserAttributeCommandInput,
  VerifyUserAttributeCommandOutput,
} from "./commands/VerifyUserAttributeCommand";
export interface CognitoIdentityProvider {
  addCustomAttributes(
    args: AddCustomAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AddCustomAttributesCommandOutput>;
  addCustomAttributes(
    args: AddCustomAttributesCommandInput,
    cb: (err: any, data?: AddCustomAttributesCommandOutput) => void
  ): void;
  addCustomAttributes(
    args: AddCustomAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AddCustomAttributesCommandOutput) => void
  ): void;
  adminAddUserToGroup(
    args: AdminAddUserToGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminAddUserToGroupCommandOutput>;
  adminAddUserToGroup(
    args: AdminAddUserToGroupCommandInput,
    cb: (err: any, data?: AdminAddUserToGroupCommandOutput) => void
  ): void;
  adminAddUserToGroup(
    args: AdminAddUserToGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminAddUserToGroupCommandOutput) => void
  ): void;
  adminConfirmSignUp(
    args: AdminConfirmSignUpCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminConfirmSignUpCommandOutput>;
  adminConfirmSignUp(
    args: AdminConfirmSignUpCommandInput,
    cb: (err: any, data?: AdminConfirmSignUpCommandOutput) => void
  ): void;
  adminConfirmSignUp(
    args: AdminConfirmSignUpCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminConfirmSignUpCommandOutput) => void
  ): void;
  adminCreateUser(
    args: AdminCreateUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminCreateUserCommandOutput>;
  adminCreateUser(
    args: AdminCreateUserCommandInput,
    cb: (err: any, data?: AdminCreateUserCommandOutput) => void
  ): void;
  adminCreateUser(
    args: AdminCreateUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminCreateUserCommandOutput) => void
  ): void;
  adminDeleteUser(
    args: AdminDeleteUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminDeleteUserCommandOutput>;
  adminDeleteUser(
    args: AdminDeleteUserCommandInput,
    cb: (err: any, data?: AdminDeleteUserCommandOutput) => void
  ): void;
  adminDeleteUser(
    args: AdminDeleteUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminDeleteUserCommandOutput) => void
  ): void;
  adminDeleteUserAttributes(
    args: AdminDeleteUserAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminDeleteUserAttributesCommandOutput>;
  adminDeleteUserAttributes(
    args: AdminDeleteUserAttributesCommandInput,
    cb: (err: any, data?: AdminDeleteUserAttributesCommandOutput) => void
  ): void;
  adminDeleteUserAttributes(
    args: AdminDeleteUserAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminDeleteUserAttributesCommandOutput) => void
  ): void;
  adminDisableProviderForUser(
    args: AdminDisableProviderForUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminDisableProviderForUserCommandOutput>;
  adminDisableProviderForUser(
    args: AdminDisableProviderForUserCommandInput,
    cb: (err: any, data?: AdminDisableProviderForUserCommandOutput) => void
  ): void;
  adminDisableProviderForUser(
    args: AdminDisableProviderForUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminDisableProviderForUserCommandOutput) => void
  ): void;
  adminDisableUser(
    args: AdminDisableUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminDisableUserCommandOutput>;
  adminDisableUser(
    args: AdminDisableUserCommandInput,
    cb: (err: any, data?: AdminDisableUserCommandOutput) => void
  ): void;
  adminDisableUser(
    args: AdminDisableUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminDisableUserCommandOutput) => void
  ): void;
  adminEnableUser(
    args: AdminEnableUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminEnableUserCommandOutput>;
  adminEnableUser(
    args: AdminEnableUserCommandInput,
    cb: (err: any, data?: AdminEnableUserCommandOutput) => void
  ): void;
  adminEnableUser(
    args: AdminEnableUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminEnableUserCommandOutput) => void
  ): void;
  adminForgetDevice(
    args: AdminForgetDeviceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminForgetDeviceCommandOutput>;
  adminForgetDevice(
    args: AdminForgetDeviceCommandInput,
    cb: (err: any, data?: AdminForgetDeviceCommandOutput) => void
  ): void;
  adminForgetDevice(
    args: AdminForgetDeviceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminForgetDeviceCommandOutput) => void
  ): void;
  adminGetDevice(
    args: AdminGetDeviceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminGetDeviceCommandOutput>;
  adminGetDevice(
    args: AdminGetDeviceCommandInput,
    cb: (err: any, data?: AdminGetDeviceCommandOutput) => void
  ): void;
  adminGetDevice(
    args: AdminGetDeviceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminGetDeviceCommandOutput) => void
  ): void;
  adminGetUser(
    args: AdminGetUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminGetUserCommandOutput>;
  adminGetUser(
    args: AdminGetUserCommandInput,
    cb: (err: any, data?: AdminGetUserCommandOutput) => void
  ): void;
  adminGetUser(
    args: AdminGetUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminGetUserCommandOutput) => void
  ): void;
  adminInitiateAuth(
    args: AdminInitiateAuthCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminInitiateAuthCommandOutput>;
  adminInitiateAuth(
    args: AdminInitiateAuthCommandInput,
    cb: (err: any, data?: AdminInitiateAuthCommandOutput) => void
  ): void;
  adminInitiateAuth(
    args: AdminInitiateAuthCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminInitiateAuthCommandOutput) => void
  ): void;
  adminLinkProviderForUser(
    args: AdminLinkProviderForUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminLinkProviderForUserCommandOutput>;
  adminLinkProviderForUser(
    args: AdminLinkProviderForUserCommandInput,
    cb: (err: any, data?: AdminLinkProviderForUserCommandOutput) => void
  ): void;
  adminLinkProviderForUser(
    args: AdminLinkProviderForUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminLinkProviderForUserCommandOutput) => void
  ): void;
  adminListDevices(
    args: AdminListDevicesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminListDevicesCommandOutput>;
  adminListDevices(
    args: AdminListDevicesCommandInput,
    cb: (err: any, data?: AdminListDevicesCommandOutput) => void
  ): void;
  adminListDevices(
    args: AdminListDevicesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminListDevicesCommandOutput) => void
  ): void;
  adminListGroupsForUser(
    args: AdminListGroupsForUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminListGroupsForUserCommandOutput>;
  adminListGroupsForUser(
    args: AdminListGroupsForUserCommandInput,
    cb: (err: any, data?: AdminListGroupsForUserCommandOutput) => void
  ): void;
  adminListGroupsForUser(
    args: AdminListGroupsForUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminListGroupsForUserCommandOutput) => void
  ): void;
  adminListUserAuthEvents(
    args: AdminListUserAuthEventsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminListUserAuthEventsCommandOutput>;
  adminListUserAuthEvents(
    args: AdminListUserAuthEventsCommandInput,
    cb: (err: any, data?: AdminListUserAuthEventsCommandOutput) => void
  ): void;
  adminListUserAuthEvents(
    args: AdminListUserAuthEventsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminListUserAuthEventsCommandOutput) => void
  ): void;
  adminRemoveUserFromGroup(
    args: AdminRemoveUserFromGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminRemoveUserFromGroupCommandOutput>;
  adminRemoveUserFromGroup(
    args: AdminRemoveUserFromGroupCommandInput,
    cb: (err: any, data?: AdminRemoveUserFromGroupCommandOutput) => void
  ): void;
  adminRemoveUserFromGroup(
    args: AdminRemoveUserFromGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminRemoveUserFromGroupCommandOutput) => void
  ): void;
  adminResetUserPassword(
    args: AdminResetUserPasswordCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminResetUserPasswordCommandOutput>;
  adminResetUserPassword(
    args: AdminResetUserPasswordCommandInput,
    cb: (err: any, data?: AdminResetUserPasswordCommandOutput) => void
  ): void;
  adminResetUserPassword(
    args: AdminResetUserPasswordCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminResetUserPasswordCommandOutput) => void
  ): void;
  adminRespondToAuthChallenge(
    args: AdminRespondToAuthChallengeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminRespondToAuthChallengeCommandOutput>;
  adminRespondToAuthChallenge(
    args: AdminRespondToAuthChallengeCommandInput,
    cb: (err: any, data?: AdminRespondToAuthChallengeCommandOutput) => void
  ): void;
  adminRespondToAuthChallenge(
    args: AdminRespondToAuthChallengeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminRespondToAuthChallengeCommandOutput) => void
  ): void;
  adminSetUserMFAPreference(
    args: AdminSetUserMFAPreferenceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminSetUserMFAPreferenceCommandOutput>;
  adminSetUserMFAPreference(
    args: AdminSetUserMFAPreferenceCommandInput,
    cb: (err: any, data?: AdminSetUserMFAPreferenceCommandOutput) => void
  ): void;
  adminSetUserMFAPreference(
    args: AdminSetUserMFAPreferenceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminSetUserMFAPreferenceCommandOutput) => void
  ): void;
  adminSetUserPassword(
    args: AdminSetUserPasswordCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminSetUserPasswordCommandOutput>;
  adminSetUserPassword(
    args: AdminSetUserPasswordCommandInput,
    cb: (err: any, data?: AdminSetUserPasswordCommandOutput) => void
  ): void;
  adminSetUserPassword(
    args: AdminSetUserPasswordCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminSetUserPasswordCommandOutput) => void
  ): void;
  adminSetUserSettings(
    args: AdminSetUserSettingsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminSetUserSettingsCommandOutput>;
  adminSetUserSettings(
    args: AdminSetUserSettingsCommandInput,
    cb: (err: any, data?: AdminSetUserSettingsCommandOutput) => void
  ): void;
  adminSetUserSettings(
    args: AdminSetUserSettingsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminSetUserSettingsCommandOutput) => void
  ): void;
  adminUpdateAuthEventFeedback(
    args: AdminUpdateAuthEventFeedbackCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminUpdateAuthEventFeedbackCommandOutput>;
  adminUpdateAuthEventFeedback(
    args: AdminUpdateAuthEventFeedbackCommandInput,
    cb: (err: any, data?: AdminUpdateAuthEventFeedbackCommandOutput) => void
  ): void;
  adminUpdateAuthEventFeedback(
    args: AdminUpdateAuthEventFeedbackCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminUpdateAuthEventFeedbackCommandOutput) => void
  ): void;
  adminUpdateDeviceStatus(
    args: AdminUpdateDeviceStatusCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminUpdateDeviceStatusCommandOutput>;
  adminUpdateDeviceStatus(
    args: AdminUpdateDeviceStatusCommandInput,
    cb: (err: any, data?: AdminUpdateDeviceStatusCommandOutput) => void
  ): void;
  adminUpdateDeviceStatus(
    args: AdminUpdateDeviceStatusCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminUpdateDeviceStatusCommandOutput) => void
  ): void;
  adminUpdateUserAttributes(
    args: AdminUpdateUserAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminUpdateUserAttributesCommandOutput>;
  adminUpdateUserAttributes(
    args: AdminUpdateUserAttributesCommandInput,
    cb: (err: any, data?: AdminUpdateUserAttributesCommandOutput) => void
  ): void;
  adminUpdateUserAttributes(
    args: AdminUpdateUserAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminUpdateUserAttributesCommandOutput) => void
  ): void;
  adminUserGlobalSignOut(
    args: AdminUserGlobalSignOutCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AdminUserGlobalSignOutCommandOutput>;
  adminUserGlobalSignOut(
    args: AdminUserGlobalSignOutCommandInput,
    cb: (err: any, data?: AdminUserGlobalSignOutCommandOutput) => void
  ): void;
  adminUserGlobalSignOut(
    args: AdminUserGlobalSignOutCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AdminUserGlobalSignOutCommandOutput) => void
  ): void;
  associateSoftwareToken(): Promise<AssociateSoftwareTokenCommandOutput>;
  associateSoftwareToken(
    args: AssociateSoftwareTokenCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AssociateSoftwareTokenCommandOutput>;
  associateSoftwareToken(
    args: AssociateSoftwareTokenCommandInput,
    cb: (err: any, data?: AssociateSoftwareTokenCommandOutput) => void
  ): void;
  associateSoftwareToken(
    args: AssociateSoftwareTokenCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AssociateSoftwareTokenCommandOutput) => void
  ): void;
  changePassword(
    args: ChangePasswordCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ChangePasswordCommandOutput>;
  changePassword(
    args: ChangePasswordCommandInput,
    cb: (err: any, data?: ChangePasswordCommandOutput) => void
  ): void;
  changePassword(
    args: ChangePasswordCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ChangePasswordCommandOutput) => void
  ): void;
  confirmDevice(
    args: ConfirmDeviceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ConfirmDeviceCommandOutput>;
  confirmDevice(
    args: ConfirmDeviceCommandInput,
    cb: (err: any, data?: ConfirmDeviceCommandOutput) => void
  ): void;
  confirmDevice(
    args: ConfirmDeviceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ConfirmDeviceCommandOutput) => void
  ): void;
  confirmForgotPassword(
    args: ConfirmForgotPasswordCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ConfirmForgotPasswordCommandOutput>;
  confirmForgotPassword(
    args: ConfirmForgotPasswordCommandInput,
    cb: (err: any, data?: ConfirmForgotPasswordCommandOutput) => void
  ): void;
  confirmForgotPassword(
    args: ConfirmForgotPasswordCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ConfirmForgotPasswordCommandOutput) => void
  ): void;
  confirmSignUp(
    args: ConfirmSignUpCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ConfirmSignUpCommandOutput>;
  confirmSignUp(
    args: ConfirmSignUpCommandInput,
    cb: (err: any, data?: ConfirmSignUpCommandOutput) => void
  ): void;
  confirmSignUp(
    args: ConfirmSignUpCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ConfirmSignUpCommandOutput) => void
  ): void;
  createGroup(
    args: CreateGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateGroupCommandOutput>;
  createGroup(
    args: CreateGroupCommandInput,
    cb: (err: any, data?: CreateGroupCommandOutput) => void
  ): void;
  createGroup(
    args: CreateGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateGroupCommandOutput) => void
  ): void;
  createIdentityProvider(
    args: CreateIdentityProviderCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateIdentityProviderCommandOutput>;
  createIdentityProvider(
    args: CreateIdentityProviderCommandInput,
    cb: (err: any, data?: CreateIdentityProviderCommandOutput) => void
  ): void;
  createIdentityProvider(
    args: CreateIdentityProviderCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateIdentityProviderCommandOutput) => void
  ): void;
  createResourceServer(
    args: CreateResourceServerCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateResourceServerCommandOutput>;
  createResourceServer(
    args: CreateResourceServerCommandInput,
    cb: (err: any, data?: CreateResourceServerCommandOutput) => void
  ): void;
  createResourceServer(
    args: CreateResourceServerCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateResourceServerCommandOutput) => void
  ): void;
  createUserImportJob(
    args: CreateUserImportJobCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateUserImportJobCommandOutput>;
  createUserImportJob(
    args: CreateUserImportJobCommandInput,
    cb: (err: any, data?: CreateUserImportJobCommandOutput) => void
  ): void;
  createUserImportJob(
    args: CreateUserImportJobCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateUserImportJobCommandOutput) => void
  ): void;
  createUserPool(
    args: CreateUserPoolCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateUserPoolCommandOutput>;
  createUserPool(
    args: CreateUserPoolCommandInput,
    cb: (err: any, data?: CreateUserPoolCommandOutput) => void
  ): void;
  createUserPool(
    args: CreateUserPoolCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateUserPoolCommandOutput) => void
  ): void;
  createUserPoolClient(
    args: CreateUserPoolClientCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateUserPoolClientCommandOutput>;
  createUserPoolClient(
    args: CreateUserPoolClientCommandInput,
    cb: (err: any, data?: CreateUserPoolClientCommandOutput) => void
  ): void;
  createUserPoolClient(
    args: CreateUserPoolClientCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateUserPoolClientCommandOutput) => void
  ): void;
  createUserPoolDomain(
    args: CreateUserPoolDomainCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateUserPoolDomainCommandOutput>;
  createUserPoolDomain(
    args: CreateUserPoolDomainCommandInput,
    cb: (err: any, data?: CreateUserPoolDomainCommandOutput) => void
  ): void;
  createUserPoolDomain(
    args: CreateUserPoolDomainCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateUserPoolDomainCommandOutput) => void
  ): void;
  deleteGroup(
    args: DeleteGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteGroupCommandOutput>;
  deleteGroup(
    args: DeleteGroupCommandInput,
    cb: (err: any, data?: DeleteGroupCommandOutput) => void
  ): void;
  deleteGroup(
    args: DeleteGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteGroupCommandOutput) => void
  ): void;
  deleteIdentityProvider(
    args: DeleteIdentityProviderCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteIdentityProviderCommandOutput>;
  deleteIdentityProvider(
    args: DeleteIdentityProviderCommandInput,
    cb: (err: any, data?: DeleteIdentityProviderCommandOutput) => void
  ): void;
  deleteIdentityProvider(
    args: DeleteIdentityProviderCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteIdentityProviderCommandOutput) => void
  ): void;
  deleteResourceServer(
    args: DeleteResourceServerCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteResourceServerCommandOutput>;
  deleteResourceServer(
    args: DeleteResourceServerCommandInput,
    cb: (err: any, data?: DeleteResourceServerCommandOutput) => void
  ): void;
  deleteResourceServer(
    args: DeleteResourceServerCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteResourceServerCommandOutput) => void
  ): void;
  deleteUser(
    args: DeleteUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteUserCommandOutput>;
  deleteUser(
    args: DeleteUserCommandInput,
    cb: (err: any, data?: DeleteUserCommandOutput) => void
  ): void;
  deleteUser(
    args: DeleteUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteUserCommandOutput) => void
  ): void;
  deleteUserAttributes(
    args: DeleteUserAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteUserAttributesCommandOutput>;
  deleteUserAttributes(
    args: DeleteUserAttributesCommandInput,
    cb: (err: any, data?: DeleteUserAttributesCommandOutput) => void
  ): void;
  deleteUserAttributes(
    args: DeleteUserAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteUserAttributesCommandOutput) => void
  ): void;
  deleteUserPool(
    args: DeleteUserPoolCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteUserPoolCommandOutput>;
  deleteUserPool(
    args: DeleteUserPoolCommandInput,
    cb: (err: any, data?: DeleteUserPoolCommandOutput) => void
  ): void;
  deleteUserPool(
    args: DeleteUserPoolCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteUserPoolCommandOutput) => void
  ): void;
  deleteUserPoolClient(
    args: DeleteUserPoolClientCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteUserPoolClientCommandOutput>;
  deleteUserPoolClient(
    args: DeleteUserPoolClientCommandInput,
    cb: (err: any, data?: DeleteUserPoolClientCommandOutput) => void
  ): void;
  deleteUserPoolClient(
    args: DeleteUserPoolClientCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteUserPoolClientCommandOutput) => void
  ): void;
  deleteUserPoolDomain(
    args: DeleteUserPoolDomainCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteUserPoolDomainCommandOutput>;
  deleteUserPoolDomain(
    args: DeleteUserPoolDomainCommandInput,
    cb: (err: any, data?: DeleteUserPoolDomainCommandOutput) => void
  ): void;
  deleteUserPoolDomain(
    args: DeleteUserPoolDomainCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteUserPoolDomainCommandOutput) => void
  ): void;
  describeIdentityProvider(
    args: DescribeIdentityProviderCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeIdentityProviderCommandOutput>;
  describeIdentityProvider(
    args: DescribeIdentityProviderCommandInput,
    cb: (err: any, data?: DescribeIdentityProviderCommandOutput) => void
  ): void;
  describeIdentityProvider(
    args: DescribeIdentityProviderCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeIdentityProviderCommandOutput) => void
  ): void;
  describeResourceServer(
    args: DescribeResourceServerCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeResourceServerCommandOutput>;
  describeResourceServer(
    args: DescribeResourceServerCommandInput,
    cb: (err: any, data?: DescribeResourceServerCommandOutput) => void
  ): void;
  describeResourceServer(
    args: DescribeResourceServerCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeResourceServerCommandOutput) => void
  ): void;
  describeRiskConfiguration(
    args: DescribeRiskConfigurationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeRiskConfigurationCommandOutput>;
  describeRiskConfiguration(
    args: DescribeRiskConfigurationCommandInput,
    cb: (err: any, data?: DescribeRiskConfigurationCommandOutput) => void
  ): void;
  describeRiskConfiguration(
    args: DescribeRiskConfigurationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeRiskConfigurationCommandOutput) => void
  ): void;
  describeUserImportJob(
    args: DescribeUserImportJobCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeUserImportJobCommandOutput>;
  describeUserImportJob(
    args: DescribeUserImportJobCommandInput,
    cb: (err: any, data?: DescribeUserImportJobCommandOutput) => void
  ): void;
  describeUserImportJob(
    args: DescribeUserImportJobCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeUserImportJobCommandOutput) => void
  ): void;
  describeUserPool(
    args: DescribeUserPoolCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeUserPoolCommandOutput>;
  describeUserPool(
    args: DescribeUserPoolCommandInput,
    cb: (err: any, data?: DescribeUserPoolCommandOutput) => void
  ): void;
  describeUserPool(
    args: DescribeUserPoolCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeUserPoolCommandOutput) => void
  ): void;
  describeUserPoolClient(
    args: DescribeUserPoolClientCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeUserPoolClientCommandOutput>;
  describeUserPoolClient(
    args: DescribeUserPoolClientCommandInput,
    cb: (err: any, data?: DescribeUserPoolClientCommandOutput) => void
  ): void;
  describeUserPoolClient(
    args: DescribeUserPoolClientCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeUserPoolClientCommandOutput) => void
  ): void;
  describeUserPoolDomain(
    args: DescribeUserPoolDomainCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeUserPoolDomainCommandOutput>;
  describeUserPoolDomain(
    args: DescribeUserPoolDomainCommandInput,
    cb: (err: any, data?: DescribeUserPoolDomainCommandOutput) => void
  ): void;
  describeUserPoolDomain(
    args: DescribeUserPoolDomainCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeUserPoolDomainCommandOutput) => void
  ): void;
  forgetDevice(
    args: ForgetDeviceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ForgetDeviceCommandOutput>;
  forgetDevice(
    args: ForgetDeviceCommandInput,
    cb: (err: any, data?: ForgetDeviceCommandOutput) => void
  ): void;
  forgetDevice(
    args: ForgetDeviceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ForgetDeviceCommandOutput) => void
  ): void;
  forgotPassword(
    args: ForgotPasswordCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ForgotPasswordCommandOutput>;
  forgotPassword(
    args: ForgotPasswordCommandInput,
    cb: (err: any, data?: ForgotPasswordCommandOutput) => void
  ): void;
  forgotPassword(
    args: ForgotPasswordCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ForgotPasswordCommandOutput) => void
  ): void;
  getCSVHeader(
    args: GetCSVHeaderCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCSVHeaderCommandOutput>;
  getCSVHeader(
    args: GetCSVHeaderCommandInput,
    cb: (err: any, data?: GetCSVHeaderCommandOutput) => void
  ): void;
  getCSVHeader(
    args: GetCSVHeaderCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCSVHeaderCommandOutput) => void
  ): void;
  getDevice(
    args: GetDeviceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetDeviceCommandOutput>;
  getDevice(
    args: GetDeviceCommandInput,
    cb: (err: any, data?: GetDeviceCommandOutput) => void
  ): void;
  getDevice(
    args: GetDeviceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetDeviceCommandOutput) => void
  ): void;
  getGroup(
    args: GetGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetGroupCommandOutput>;
  getGroup(
    args: GetGroupCommandInput,
    cb: (err: any, data?: GetGroupCommandOutput) => void
  ): void;
  getGroup(
    args: GetGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetGroupCommandOutput) => void
  ): void;
  getIdentityProviderByIdentifier(
    args: GetIdentityProviderByIdentifierCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetIdentityProviderByIdentifierCommandOutput>;
  getIdentityProviderByIdentifier(
    args: GetIdentityProviderByIdentifierCommandInput,
    cb: (err: any, data?: GetIdentityProviderByIdentifierCommandOutput) => void
  ): void;
  getIdentityProviderByIdentifier(
    args: GetIdentityProviderByIdentifierCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetIdentityProviderByIdentifierCommandOutput) => void
  ): void;
  getLogDeliveryConfiguration(
    args: GetLogDeliveryConfigurationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetLogDeliveryConfigurationCommandOutput>;
  getLogDeliveryConfiguration(
    args: GetLogDeliveryConfigurationCommandInput,
    cb: (err: any, data?: GetLogDeliveryConfigurationCommandOutput) => void
  ): void;
  getLogDeliveryConfiguration(
    args: GetLogDeliveryConfigurationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetLogDeliveryConfigurationCommandOutput) => void
  ): void;
  getSigningCertificate(
    args: GetSigningCertificateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetSigningCertificateCommandOutput>;
  getSigningCertificate(
    args: GetSigningCertificateCommandInput,
    cb: (err: any, data?: GetSigningCertificateCommandOutput) => void
  ): void;
  getSigningCertificate(
    args: GetSigningCertificateCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetSigningCertificateCommandOutput) => void
  ): void;
  getUICustomization(
    args: GetUICustomizationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetUICustomizationCommandOutput>;
  getUICustomization(
    args: GetUICustomizationCommandInput,
    cb: (err: any, data?: GetUICustomizationCommandOutput) => void
  ): void;
  getUICustomization(
    args: GetUICustomizationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetUICustomizationCommandOutput) => void
  ): void;
  getUser(
    args: GetUserCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetUserCommandOutput>;
  getUser(
    args: GetUserCommandInput,
    cb: (err: any, data?: GetUserCommandOutput) => void
  ): void;
  getUser(
    args: GetUserCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetUserCommandOutput) => void
  ): void;
  getUserAttributeVerificationCode(
    args: GetUserAttributeVerificationCodeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetUserAttributeVerificationCodeCommandOutput>;
  getUserAttributeVerificationCode(
    args: GetUserAttributeVerificationCodeCommandInput,
    cb: (err: any, data?: GetUserAttributeVerificationCodeCommandOutput) => void
  ): void;
  getUserAttributeVerificationCode(
    args: GetUserAttributeVerificationCodeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetUserAttributeVerificationCodeCommandOutput) => void
  ): void;
  getUserPoolMfaConfig(
    args: GetUserPoolMfaConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetUserPoolMfaConfigCommandOutput>;
  getUserPoolMfaConfig(
    args: GetUserPoolMfaConfigCommandInput,
    cb: (err: any, data?: GetUserPoolMfaConfigCommandOutput) => void
  ): void;
  getUserPoolMfaConfig(
    args: GetUserPoolMfaConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetUserPoolMfaConfigCommandOutput) => void
  ): void;
  globalSignOut(
    args: GlobalSignOutCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GlobalSignOutCommandOutput>;
  globalSignOut(
    args: GlobalSignOutCommandInput,
    cb: (err: any, data?: GlobalSignOutCommandOutput) => void
  ): void;
  globalSignOut(
    args: GlobalSignOutCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GlobalSignOutCommandOutput) => void
  ): void;
  initiateAuth(
    args: InitiateAuthCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<InitiateAuthCommandOutput>;
  initiateAuth(
    args: InitiateAuthCommandInput,
    cb: (err: any, data?: InitiateAuthCommandOutput) => void
  ): void;
  initiateAuth(
    args: InitiateAuthCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: InitiateAuthCommandOutput) => void
  ): void;
  listDevices(
    args: ListDevicesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDevicesCommandOutput>;
  listDevices(
    args: ListDevicesCommandInput,
    cb: (err: any, data?: ListDevicesCommandOutput) => void
  ): void;
  listDevices(
    args: ListDevicesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDevicesCommandOutput) => void
  ): void;
  listGroups(
    args: ListGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListGroupsCommandOutput>;
  listGroups(
    args: ListGroupsCommandInput,
    cb: (err: any, data?: ListGroupsCommandOutput) => void
  ): void;
  listGroups(
    args: ListGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListGroupsCommandOutput) => void
  ): void;
  listIdentityProviders(
    args: ListIdentityProvidersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListIdentityProvidersCommandOutput>;
  listIdentityProviders(
    args: ListIdentityProvidersCommandInput,
    cb: (err: any, data?: ListIdentityProvidersCommandOutput) => void
  ): void;
  listIdentityProviders(
    args: ListIdentityProvidersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListIdentityProvidersCommandOutput) => void
  ): void;
  listResourceServers(
    args: ListResourceServersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListResourceServersCommandOutput>;
  listResourceServers(
    args: ListResourceServersCommandInput,
    cb: (err: any, data?: ListResourceServersCommandOutput) => void
  ): void;
  listResourceServers(
    args: ListResourceServersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListResourceServersCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListTagsForResourceCommandOutput>;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listUserImportJobs(
    args: ListUserImportJobsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListUserImportJobsCommandOutput>;
  listUserImportJobs(
    args: ListUserImportJobsCommandInput,
    cb: (err: any, data?: ListUserImportJobsCommandOutput) => void
  ): void;
  listUserImportJobs(
    args: ListUserImportJobsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListUserImportJobsCommandOutput) => void
  ): void;
  listUserPoolClients(
    args: ListUserPoolClientsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListUserPoolClientsCommandOutput>;
  listUserPoolClients(
    args: ListUserPoolClientsCommandInput,
    cb: (err: any, data?: ListUserPoolClientsCommandOutput) => void
  ): void;
  listUserPoolClients(
    args: ListUserPoolClientsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListUserPoolClientsCommandOutput) => void
  ): void;
  listUserPools(
    args: ListUserPoolsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListUserPoolsCommandOutput>;
  listUserPools(
    args: ListUserPoolsCommandInput,
    cb: (err: any, data?: ListUserPoolsCommandOutput) => void
  ): void;
  listUserPools(
    args: ListUserPoolsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListUserPoolsCommandOutput) => void
  ): void;
  listUsers(
    args: ListUsersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListUsersCommandOutput>;
  listUsers(
    args: ListUsersCommandInput,
    cb: (err: any, data?: ListUsersCommandOutput) => void
  ): void;
  listUsers(
    args: ListUsersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListUsersCommandOutput) => void
  ): void;
  listUsersInGroup(
    args: ListUsersInGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListUsersInGroupCommandOutput>;
  listUsersInGroup(
    args: ListUsersInGroupCommandInput,
    cb: (err: any, data?: ListUsersInGroupCommandOutput) => void
  ): void;
  listUsersInGroup(
    args: ListUsersInGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListUsersInGroupCommandOutput) => void
  ): void;
  resendConfirmationCode(
    args: ResendConfirmationCodeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ResendConfirmationCodeCommandOutput>;
  resendConfirmationCode(
    args: ResendConfirmationCodeCommandInput,
    cb: (err: any, data?: ResendConfirmationCodeCommandOutput) => void
  ): void;
  resendConfirmationCode(
    args: ResendConfirmationCodeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ResendConfirmationCodeCommandOutput) => void
  ): void;
  respondToAuthChallenge(
    args: RespondToAuthChallengeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RespondToAuthChallengeCommandOutput>;
  respondToAuthChallenge(
    args: RespondToAuthChallengeCommandInput,
    cb: (err: any, data?: RespondToAuthChallengeCommandOutput) => void
  ): void;
  respondToAuthChallenge(
    args: RespondToAuthChallengeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RespondToAuthChallengeCommandOutput) => void
  ): void;
  revokeToken(
    args: RevokeTokenCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RevokeTokenCommandOutput>;
  revokeToken(
    args: RevokeTokenCommandInput,
    cb: (err: any, data?: RevokeTokenCommandOutput) => void
  ): void;
  revokeToken(
    args: RevokeTokenCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RevokeTokenCommandOutput) => void
  ): void;
  setLogDeliveryConfiguration(
    args: SetLogDeliveryConfigurationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SetLogDeliveryConfigurationCommandOutput>;
  setLogDeliveryConfiguration(
    args: SetLogDeliveryConfigurationCommandInput,
    cb: (err: any, data?: SetLogDeliveryConfigurationCommandOutput) => void
  ): void;
  setLogDeliveryConfiguration(
    args: SetLogDeliveryConfigurationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SetLogDeliveryConfigurationCommandOutput) => void
  ): void;
  setRiskConfiguration(
    args: SetRiskConfigurationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SetRiskConfigurationCommandOutput>;
  setRiskConfiguration(
    args: SetRiskConfigurationCommandInput,
    cb: (err: any, data?: SetRiskConfigurationCommandOutput) => void
  ): void;
  setRiskConfiguration(
    args: SetRiskConfigurationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SetRiskConfigurationCommandOutput) => void
  ): void;
  setUICustomization(
    args: SetUICustomizationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SetUICustomizationCommandOutput>;
  setUICustomization(
    args: SetUICustomizationCommandInput,
    cb: (err: any, data?: SetUICustomizationCommandOutput) => void
  ): void;
  setUICustomization(
    args: SetUICustomizationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SetUICustomizationCommandOutput) => void
  ): void;
  setUserMFAPreference(
    args: SetUserMFAPreferenceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SetUserMFAPreferenceCommandOutput>;
  setUserMFAPreference(
    args: SetUserMFAPreferenceCommandInput,
    cb: (err: any, data?: SetUserMFAPreferenceCommandOutput) => void
  ): void;
  setUserMFAPreference(
    args: SetUserMFAPreferenceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SetUserMFAPreferenceCommandOutput) => void
  ): void;
  setUserPoolMfaConfig(
    args: SetUserPoolMfaConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SetUserPoolMfaConfigCommandOutput>;
  setUserPoolMfaConfig(
    args: SetUserPoolMfaConfigCommandInput,
    cb: (err: any, data?: SetUserPoolMfaConfigCommandOutput) => void
  ): void;
  setUserPoolMfaConfig(
    args: SetUserPoolMfaConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SetUserPoolMfaConfigCommandOutput) => void
  ): void;
  setUserSettings(
    args: SetUserSettingsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SetUserSettingsCommandOutput>;
  setUserSettings(
    args: SetUserSettingsCommandInput,
    cb: (err: any, data?: SetUserSettingsCommandOutput) => void
  ): void;
  setUserSettings(
    args: SetUserSettingsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SetUserSettingsCommandOutput) => void
  ): void;
  signUp(
    args: SignUpCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SignUpCommandOutput>;
  signUp(
    args: SignUpCommandInput,
    cb: (err: any, data?: SignUpCommandOutput) => void
  ): void;
  signUp(
    args: SignUpCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SignUpCommandOutput) => void
  ): void;
  startUserImportJob(
    args: StartUserImportJobCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartUserImportJobCommandOutput>;
  startUserImportJob(
    args: StartUserImportJobCommandInput,
    cb: (err: any, data?: StartUserImportJobCommandOutput) => void
  ): void;
  startUserImportJob(
    args: StartUserImportJobCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartUserImportJobCommandOutput) => void
  ): void;
  stopUserImportJob(
    args: StopUserImportJobCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopUserImportJobCommandOutput>;
  stopUserImportJob(
    args: StopUserImportJobCommandInput,
    cb: (err: any, data?: StopUserImportJobCommandOutput) => void
  ): void;
  stopUserImportJob(
    args: StopUserImportJobCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StopUserImportJobCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TagResourceCommandOutput>;
  tagResource(
    args: TagResourceCommandInput,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UntagResourceCommandOutput>;
  untagResource(
    args: UntagResourceCommandInput,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  updateAuthEventFeedback(
    args: UpdateAuthEventFeedbackCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateAuthEventFeedbackCommandOutput>;
  updateAuthEventFeedback(
    args: UpdateAuthEventFeedbackCommandInput,
    cb: (err: any, data?: UpdateAuthEventFeedbackCommandOutput) => void
  ): void;
  updateAuthEventFeedback(
    args: UpdateAuthEventFeedbackCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateAuthEventFeedbackCommandOutput) => void
  ): void;
  updateDeviceStatus(
    args: UpdateDeviceStatusCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateDeviceStatusCommandOutput>;
  updateDeviceStatus(
    args: UpdateDeviceStatusCommandInput,
    cb: (err: any, data?: UpdateDeviceStatusCommandOutput) => void
  ): void;
  updateDeviceStatus(
    args: UpdateDeviceStatusCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateDeviceStatusCommandOutput) => void
  ): void;
  updateGroup(
    args: UpdateGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateGroupCommandOutput>;
  updateGroup(
    args: UpdateGroupCommandInput,
    cb: (err: any, data?: UpdateGroupCommandOutput) => void
  ): void;
  updateGroup(
    args: UpdateGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateGroupCommandOutput) => void
  ): void;
  updateIdentityProvider(
    args: UpdateIdentityProviderCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateIdentityProviderCommandOutput>;
  updateIdentityProvider(
    args: UpdateIdentityProviderCommandInput,
    cb: (err: any, data?: UpdateIdentityProviderCommandOutput) => void
  ): void;
  updateIdentityProvider(
    args: UpdateIdentityProviderCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateIdentityProviderCommandOutput) => void
  ): void;
  updateResourceServer(
    args: UpdateResourceServerCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateResourceServerCommandOutput>;
  updateResourceServer(
    args: UpdateResourceServerCommandInput,
    cb: (err: any, data?: UpdateResourceServerCommandOutput) => void
  ): void;
  updateResourceServer(
    args: UpdateResourceServerCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateResourceServerCommandOutput) => void
  ): void;
  updateUserAttributes(
    args: UpdateUserAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateUserAttributesCommandOutput>;
  updateUserAttributes(
    args: UpdateUserAttributesCommandInput,
    cb: (err: any, data?: UpdateUserAttributesCommandOutput) => void
  ): void;
  updateUserAttributes(
    args: UpdateUserAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateUserAttributesCommandOutput) => void
  ): void;
  updateUserPool(
    args: UpdateUserPoolCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateUserPoolCommandOutput>;
  updateUserPool(
    args: UpdateUserPoolCommandInput,
    cb: (err: any, data?: UpdateUserPoolCommandOutput) => void
  ): void;
  updateUserPool(
    args: UpdateUserPoolCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateUserPoolCommandOutput) => void
  ): void;
  updateUserPoolClient(
    args: UpdateUserPoolClientCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateUserPoolClientCommandOutput>;
  updateUserPoolClient(
    args: UpdateUserPoolClientCommandInput,
    cb: (err: any, data?: UpdateUserPoolClientCommandOutput) => void
  ): void;
  updateUserPoolClient(
    args: UpdateUserPoolClientCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateUserPoolClientCommandOutput) => void
  ): void;
  updateUserPoolDomain(
    args: UpdateUserPoolDomainCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateUserPoolDomainCommandOutput>;
  updateUserPoolDomain(
    args: UpdateUserPoolDomainCommandInput,
    cb: (err: any, data?: UpdateUserPoolDomainCommandOutput) => void
  ): void;
  updateUserPoolDomain(
    args: UpdateUserPoolDomainCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateUserPoolDomainCommandOutput) => void
  ): void;
  verifySoftwareToken(
    args: VerifySoftwareTokenCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<VerifySoftwareTokenCommandOutput>;
  verifySoftwareToken(
    args: VerifySoftwareTokenCommandInput,
    cb: (err: any, data?: VerifySoftwareTokenCommandOutput) => void
  ): void;
  verifySoftwareToken(
    args: VerifySoftwareTokenCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: VerifySoftwareTokenCommandOutput) => void
  ): void;
  verifyUserAttribute(
    args: VerifyUserAttributeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<VerifyUserAttributeCommandOutput>;
  verifyUserAttribute(
    args: VerifyUserAttributeCommandInput,
    cb: (err: any, data?: VerifyUserAttributeCommandOutput) => void
  ): void;
  verifyUserAttribute(
    args: VerifyUserAttributeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: VerifyUserAttributeCommandOutput) => void
  ): void;
}
export declare class CognitoIdentityProvider
  extends CognitoIdentityProviderClient
  implements CognitoIdentityProvider {}
