
const express = require('express');
const multer = require("multer");
const { errorResponse, successResponse, filter_Old_New_Data, activityLog } = require('../../utils/utils');
const { Create_User_Role, Get_Single_Role, Update_User_Role, Get_All_Roles, Delete_Role } = require('../../models/User_Role/User_Role');

const router = express.Router();
const upload = multer();

async function create_user_role(req, res) {
    try {
        let body = req.body;

        let result = await Create_User_Role(body.role_name, JSON.stringify(body.permissions));

        if (!result || result instanceof Error) return errorResponse(res, 400, "Failed to create user");

        await activityLog('Added Role', 'User Role Module', "10", "POST", null, JSON.stringify(body));

        successResponse(res, "Role created successfully");

    } catch (error) {
        errorResponse(res, 500, error.message);
    }
}

async function update_user_role(req, res) {
    try {
        let body = req.body;
        let id = req.query.id;

        if (!id) return errorResponse(res, 400, "Provide valid role id");

        const currentRole = await Get_Single_Role(id);

        if (!currentRole || currentRole.length == 0) return errorResponse(res, 401, "Role not found");

        const result = await Update_User_Role(id, body.role_name, JSON.stringify(body.permissions));

        if (!result || result instanceof Error) return errorResponse(res, 400, "Failed to create user role");

        if (result.affectedRows === 0) return errorResponse(res, 404, "No changes made");

        // get changed values
        const { changes, new_value_log } = filter_Old_New_Data(currentRole[0], body);

        await activityLog("Updated Role", "User Role Module", id, "UPDATE", JSON.stringify(changes), JSON.stringify(new_value_log));

        successResponse(res, "Role Updated Successfully");

    } catch (error) {
        errorResponse(res, 500, error.message);
    }
}

async function get_all_roles(req, res) {
    try {
        const result = await Get_All_Roles();

        result.forEach(role => {
            role.permissions = JSON.parse(role.permissions);
        });

        successResponse(res, "Details fetched successfullt", result);

    } catch (error) {
        console.log(error)
        errorResponse(res, 500, "Internal server error");
    }
}

async function get_single_role(req, res) {
    try {
        let id = req.query.id;

        if (!id) return errorResponse(res, 404, "Record Not found");

        const result = await Get_Single_Role(id);

        result.length > 0 ?  successResponse(res, "Details Fetched Successfully", result[0]) : errorResponse(res, 404, "Record not found");

    } catch (error) {
        errorResponse(res, 500, "Internal server error");
    }
}

async function delete_role(req, res) {
    try {
        let id = req.query.id;

        if (!id) return errorResponse(res, 404, "Role ID not found");

        const result = await Delete_Role(id);

        if (result.affectedRows === 0) {
            return errorResponse(res, 404, "User not found");
        } else {
            await activityLog("Deleted Role", "User Role Module", id, "DELETE", null, null);

            successResponse(res, "Role deleted successfully");
        }

    } catch (error) {
        errorResponse(res, 500, error.message);
    }
}

router.post("/create_role", upload.none(), create_user_role);
router.put("/update_role", upload.none(), update_user_role);
router.get("/get_all_roles", get_all_roles);
router.get("/get_single_role", get_single_role);
router.delete("/delete_role", delete_role);

module.exports = router;
