import Header from '@/components/template/Header'
import SidePanel from '@/components/template/SidePanel'
import UserDropdown from '@/components/template/UserDropdown'
import LanguageSelector from '@/components/template/LanguageSelector'
import Notification from '@/components/template/Notification'
import MobileNav from '@/components/template/MobileNav'
import Search from '@/components/template/Search'
import StackedSideNav from '@/components/template/StackedSideNav'
import View from '@/views'
import { useLocation } from 'react-router-dom'
import Input from '@/components/ui/Input'
import { IoSearch } from 'react-icons/io5'
import { useAppSelector } from '@/store'
import { useEffect, useState } from 'react'
// import { setFilteredAppListReducer } from '@/store/slices/customeSlices/appList'
import { useDispatch } from 'react-redux'
import { setFilterAppListReducer, setSearchingText } from '@/store/slices/customeSlices/filterAppList'

// import type {AppDataType} from '@/views/portal/portal-dashboard/components/ProjectListContent'
type AppDataType = {
    app_id: string,
    name: string,
    picture: string,
    app_url: string
}[]
const HeaderActionsStart = () => {
    return (
        <>
            <MobileNav />
            <Search />
        </>
    )
}

export const HeaderActionsStart2 = ({ appList, searchText }: { appList: AppDataType,  searchText: string }) => {

    const dispatch = useDispatch()
    const [filteredAppList, setFilteredAppList] = useState(appList);
    const [suggestionDivShow, setSuggestionDivShow] = useState<boolean>(false)

    const handleClickOutside = (event: any) => {
        if (searchText && !event.target.closest('.closeWrapperSearch')) {
            // setSearchText('')
            setSuggestionDivShow(false)

        }
    };

    useEffect(() => {
        // Add event listener when component mounts
        document.body.addEventListener('click', handleClickOutside);

        // Remove event listener when component unmounts
        return () => {
            document.body.removeEventListener('click', handleClickOutside);
        };
    }, [searchText]);


    return (
        <>
            <div className='flex items-center  flex-1'>
                <img className='mr-8' width={55} src="/img/logo/logo-light-streamline.png" alt="Nulou Auth logo"></img>
                <div className='flex-1 flex items-center justify-center'>
                    <div className='w-1/2 relative sm:inline-block hidden closeWrapperSearch'>
                        <Input
                            className='w-100'
                            value={searchText}
                            onChange={(e: React.ChangeEvent<HTMLInputElement>) => {
                                setSuggestionDivShow(true)
                                // setSearchText(e.target.value)
                                dispatch(setSearchingText(e.target.value))
                            }}
                            placeholder="Search App"
                            prefix={<IoSearch size={23} />}
                        />
                        {/* {
                    (filteredAppList.length > 0 && searchText) ? <div className={`absolute border w-96 bg-white p-5 ${suggestionDivShow?'':'hidden'}`}>
                        <ul>
                            {
                                filteredAppList.map((app, index) => {
                                    return <li key={index} className='border my-4'>
                                        <div className='flex'>
                                            <img width={50} src={`${import.meta.env.VITE_BASE_URL}/public${app.picture}`} alt="" />
                                            <span>{app.name}</span>
                                        </div>
                                    </li>
                                })
                            }

                        </ul>
                    </div>
                        : null
                } */}

                    </div>
                </div>
            </div>
        </>
    )
}

const HeaderActionsEnd = () => {
    return (
        <>
            <LanguageSelector />
            <Notification />
            <SidePanel />
            <UserDropdown hoverable={false} />
        </>
    )
}
export const HeaderActionsEnd2 = () => {
    return (
        <>
            <SidePanel />
            <UserDropdown hoverable={false} />
        </>
    )
}

const StackedSideLayout = () => {
    const { appList } = useAppSelector((state) => state.appList.appList)
    const dispatch = useDispatch()
    // const [searchText, setSearchText] = useState<string>('');
    const {searchingText}=useAppSelector((state)=>state.filterAppList.filterAppList)

    const location = useLocation()
    const hideSideBar: boolean = location.pathname == "/auth/portal"

    useEffect(() => {
        const filteredData = appList.filter((app) => {
            const appName = app.name.toLowerCase();
            const searchQuery = searchingText.toLowerCase();
            return appName.includes(searchQuery);
        });
        dispatch(setFilterAppListReducer(filteredData))
        // setFilteredAppList(filteredData);
    }, [searchingText, appList]);
    return (
        <div className="app-layout-stacked-side flex flex-auto flex-col">
            <div className="flex flex-auto min-w-0">
                {hideSideBar ? null : <StackedSideNav />}

                <div className="flex flex-col flex-auto min-h-screen min-w-0 relative w-full">
                    {
                        hideSideBar ? <>
                            <Header
                                className="shadow dark:shadow-2xl "
                                headerStart={<HeaderActionsStart2
                                    appList={appList}
                                    // setSearchText={setSearchText}
                                    searchText={searchingText}
                                />}
                                headerEnd={<HeaderActionsEnd2 />}
                            />
                            <div className='w-100 relative sm:hidden'>
                                <Input
                                    className='w-100'
                                    value={searchingText}
                                    onChange={(e) => {
                                        // setSuggestionDivShow(true)
                                        dispatch(setSearchingText(e.target.value))
                                    }}
                                    placeholder="Search App"
                                    prefix={<IoSearch size={23} />}
                                />

                            </div>
                        </>
                            :
                            <Header
                                className="shadow dark:shadow-2xl"
                                headerStart={<HeaderActionsStart />}
                                headerEnd={<HeaderActionsEnd />}
                            />
                    }

                    <div className="h-full flex flex-auto flex-col">
                        <View />
                    </div>
                </div>
            </div>
        </div>
    )
}

export default StackedSideLayout
