import { APP_PREFIX_PATH } from '@/constants/route.constant'
import {
    NAV_ITEM_TYPE_COLLAPSE,
    NAV_ITEM_TYPE_ITEM,
} from '@/constants/navigation.constant'
import { ADMIN, USER } from '@/constants/roles.constant'
import type { NavigationTree } from '@/@types/navigation'

const appsNavigationConfig: NavigationTree[] = [
    {
        key: 'nav.appsData',
        path: '',
        title: 'Apps',
        translateKey: 'appsData.apps',
        icon: 'customeAppIcon',
        type: NAV_ITEM_TYPE_COLLAPSE,
        authority: [ADMIN, USER],
        subMenu: [
            {
                key: 'appsData.addApps',
                path: `${APP_PREFIX_PATH}/addApps`,
                title: 'Add Apps',
                translateKey: 'nav.appsData.addApps',
                icon: '',
                type: NAV_ITEM_TYPE_ITEM,
                authority: [ADMIN, USER],
                subMenu: [],
            },
            {
                key: 'appsData.allApps',
                path: `${APP_PREFIX_PATH}/allApps`,
                title: 'All Apps',
                translateKey: 'nav.appsData.allApps',
                icon: '',
                type: NAV_ITEM_TYPE_ITEM,
                authority: [ADMIN, USER],
                subMenu: [],
            },
        ],
    },
]

export default appsNavigationConfig
