
const { CognitoIdentityProviderClient, InitiateAuthCommand } = require('@aws-sdk/client-cognito-identity-provider');
require('dotenv').config();
const { COGNITO_CLIENT_ID, AWS_REGION, COGNITO_CLIENT_SECRET } = process.env;
const crypto = require("crypto");
const { errorResponse } = require('../utils/utils');

// Generate Secret Hash
const generateSecretHash = (username) => {
    const hmac = crypto.createHmac('sha256', COGNITO_CLIENT_SECRET);
    hmac.update(username + COGNITO_CLIENT_ID);
    return hmac.digest('base64');
};

const client = new CognitoIdentityProviderClient({ region: AWS_REGION });

const authenticateUser = async (username, password) => {
    const secretHash = generateSecretHash(username);

    const command = new InitiateAuthCommand({
        AuthFlow: 'USER_PASSWORD_AUTH',
        ClientId: COGNITO_CLIENT_ID,
        AuthParameters: {
            USERNAME: username,
            PASSWORD: password,
            SECRET_HASH: secretHash,
        },
    });

    try {
        const result = await client.send(command);
        return result.AuthenticationResult;
    } catch (error) {
        if (error.name === 'NotAuthorizedException') {
            if (error.message === 'Incorrect username or password') {
                return errorResponse(res, 401, "Incorrect username or password");
            }
        }

        console.log("Authentication error", error);
        return errorResponse(res, 500, "An error occurred during authentication");
    }
};

// module.exports = authenticateUser;
// module.exports = { authenticateUser };
module.exports = { authenticateUser, generateSecretHash};
