import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ForgetDeviceRequestFilterSensitiveLog } from "../models/models_0";
import { de_ForgetDeviceCommand, se_ForgetDeviceCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class ForgetDeviceCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSCognitoIdentityProviderService", "ForgetDevice", {})
    .n("CognitoIdentityProviderClient", "ForgetDeviceCommand")
    .f(ForgetDeviceRequestFilterSensitiveLog, void 0)
    .ser(se_ForgetDeviceCommand)
    .de(de_ForgetDeviceCommand)
    .build() {
}
