
import axios from "axios";

const api = axios.create({
    baseURL: "http://localhost:6000",
    timeout:  6000,
    headers: {
        'Content-Type': 'application/json',
    }
});


export const getAllRequest = (url:any) => {
    return api.get(url);
}

export const getOneRequest = (url:any,id:any) => {
    return api.get(`${url}/${id}`);
}

export const postRequest = (url:any,data:any) => {
    return api.post(url,data);
}

export const putRequest = (url:any,id:any,data:any) => {
    return api.put(`${url}/${id}`, data);
}

export const deleteRequest = (url:any, id:any) => {
    return api.delete(`${url}/${id}`);
}

export default api;
