import { APP_PREFIX_PATH } from '@/constants/route.constant'
import {
    NAV_ITEM_TYPE_COLLAPSE,
    NAV_ITEM_TYPE_ITEM,
} from '@/constants/navigation.constant'
import { ADMIN, USER } from '@/constants/roles.constant'
import type { NavigationTree } from '@/@types/navigation'

const settingNavigationConfig: NavigationTree[] = [
    {
        key: 'nav.settingNav',
        path: '',
        title: 'Settings',
        translateKey: 'settingNav.setting',
        icon: 'customSettingIcon',
        type: NAV_ITEM_TYPE_COLLAPSE,
        authority: [ADMIN, USER],
        subMenu: [
            {
                key: 'settingNav.setting',
                path: `${APP_PREFIX_PATH}/setting/AWS-API`,
                title: 'External Api',
                translateKey: 'nav.settingNav.externalApi',
                icon: '',
                type: NAV_ITEM_TYPE_ITEM,
                authority: [ADMIN, USER],
                subMenu: [],
            }
        ],
    },
]

export default settingNavigationConfig
