import { lazy } from 'react'
import { APP_PREFIX_PATH } from '@/constants/route.constant'
import { ADMIN, USER } from '@/constants/roles.constant'
import type { Routes } from '@/@types/routes'

const usersRoute: Routes = [
    {
        key: 'usersData.addUsers',
        path: `${APP_PREFIX_PATH}/users/addUsers`,
        component: lazy(() => import('@/views/users/addUsers')),
        authority: [ADMIN, USER],
    },
    {
        key: 'usersData.allUsers',
        path: `${APP_PREFIX_PATH}/users/allUsers`,
        component: lazy(() => import('@/views/users/allUsers')),
        authority: [ADMIN, USER],
    },
    {
        key: 'usersData.updateUsers',
        path: `${APP_PREFIX_PATH}/users/updateUsers/:id`,
        component: lazy(() => import('@/views/users/updateUser')),
        authority: [ADMIN, USER],
    },
]

export default usersRoute
