import { Button, Card } from '@/components/ui'
import React from 'react'
import { HiOutlineClipboardCheck } from 'react-icons/hi'
import { Link } from 'react-router-dom'



type AppDataType = {
    projects: {
        app_id: string,
        name: string,
        picture: string,
        app_url: string,
        app_description:string,
    }
}

const GridItem = ({ projects }: AppDataType) => {
    const { name, picture, app_url,app_description } = projects
    return (
        <>
            {/* <Card bodyClass="h-full group  hover:bg-[#e5e7eb] hover:text-white">
               <a  href={app_url} target="_blank" rel="noopener noreferrer">

               <div className="flex flex-col justify-between h-full">
                    <div className="flex justify-center flex-col items-center">
                        <img width={100} src={`${import.meta.env.VITE_BASE_URL}/public${picture}`} alt="" />
                            <h6 className='group-hover:text-[#2e2d2d]' >{name}</h6>
                    </div>
                </div>
               </a>
            </Card> */}

            <Card bodyClass="h-full">

                <div className="flex flex-col justify-between h-full">
                    <div className='text-center  flex items-center justify-center'>
                        <img width={120} src={`${picture}`} alt="" />
                    </div>
                    <div className="flex justify-center items-center mt-4">
                       <a href={app_url} target="_blank" rel="noopener noreferrer">
                            <h4>{name}</h4>
                       </a>
                        {/* <ItemDropdown /> */}
                    </div>
                    <p className="mt-4">{app_description}</p>
                    <div className="mt-3">
                        {/* <ProgressionBar progression={progression} /> */}
                        <div className="flex items-center justify-between mt-2">
                            {/* <Members members={member} /> */}
                            <div className="flex items-center rounded-full font-semibold text-xs">
                           <a href={app_url} target="_blank" rel="noopener noreferrer">
                           <Button variant="solid">Open APP</Button>
                           </a>
                            </div>
                        </div>
                    </div>
                </div>
            </Card>
        </>
    )
}

export default GridItem